#ifdef(tex_simp)
default{pigment{rgb x}}
#declare Pole_Tex = texture{pigment{rgb 0.5}}
#declare Base_Tex = texture{pigment{rgb 0.75}}
#declare Ring_Clamp_Tex = texture{pigment{rgb 0.2}}
#else
default{pigment{rgb x}finish{phong 0.9 phong_size 60}}
#declare Pole_Tex = texture{VertMetal}
#declare Base_Tex = texture{Knife_Tex}
#declare Ring_Clamp_Tex = texture{PolishedSteel}
#end
//----------------------------------------------Stuff-----------------------------------------------
#declare box_x = 8
#declare box_z = 5
#declare box_y = 0.5

#declare Base = union{
box{<box_x/2,box_y/2,box_z/2><-box_x/2,-box_y/2,-box_z/2>}
cylinder{-box_x/2*x,box_x/2*x,box_y/2 translate -box_z/2*z}
cylinder{-box_x/2*x,box_x/2*x,box_y/2 translate box_z/2*z}
cylinder{-box_z/2*z,box_z/2*z,box_y/2 translate -box_x/2*x}
cylinder{-box_z/2*z,box_z/2*z,box_y/2 translate box_x/2*x}
sphere{-box_x/2*x-box_z/2*z,box_y/2}
sphere{-box_x/2*x+box_z/2*z,box_y/2}
sphere{+box_x/2*x-box_z/2*z,box_y/2}
sphere{+box_x/2*x+box_z/2*z,box_y/2}

#declare Leg =union{
cylinder{0,-1*y,0.5}
torus{0.4,0.1 translate -1*y}
}

#declare leg_spc = 0.3
object{Leg translate<-box_x/2+leg_spc,0,-box_z/2+leg_spc>}
object{Leg translate<-box_x/2+leg_spc,0,box_z/2-leg_spc>}
object{Leg translate<box_x/2-leg_spc,0,box_z/2-leg_spc>}
object{Leg translate<box_x/2-leg_spc,0,-box_z/2+leg_spc>}
#declare top_o_base = 1.1+box_y/2
texture{Base_Tex}
translate 1.1*y
}

#declare Pole = union{
#declare pole_hei = 13
#declare pole_rad = 0.4
#declare pole_smo_rad = 0.1
torus{pole_rad-pole_smo_rad,pole_smo_rad translate top_o_base*y+pole_hei*y}
cylinder{top_o_base*y,top_o_base*y+pole_hei*y,pole_rad}
texture{Pole_Tex}
translate (-box_x/2+1)*x
}

#declare Clamp = difference{
#declare hei = 0.8
#declare rad = 1
#declare thick = 0.5
cylinder{hei/2*y,-hei/2*y,rad+thick}
cylinder{hei*y,-hei*y,rad}
plane{z,0}
}


#declare Pin = union{
cylinder{hei/4*y,-hei/4*y,rad/2 scale<0.75,1,1>}
cylinder{0,2*x,hei/3}
cone{0,hei/3,(-rad/2*0.75)*x,hei/4}
translate -2*x
}

#declare Ring_Clamp = union{
#declare Ring_Sze = 3
torus{Ring_Sze,0.2}
cone{-Ring_Sze*x,0.2,-Ring_Sze*x-1*x,0.4}
cylinder{-Ring_Sze*x-1*x,-Ring_Sze*x-3*x,0.4}
#declare where = 1/3*(rad+thick)
#declare a = where*where
#declare b = (thick+rad)*(thick+rad)
#declare c = (rad+thick)-sqrt((a+b))
union{
object{Clamp}
#declare opening = rad*1.5
object{Pin rotate 45*x translate hei/2*z-rad/2*x}
translate (-rad-thick/2-3-Ring_Sze-c)*x-where*z
}
texture{Ring_Clamp_Tex}
translate (rad+thick/2+3+Ring_Sze+c-rad/4)*x+where*z
}

#declare Ring_Stand = union{
object{Pole}
object{Base}
object{Ring_Clamp scale 0.55 translate pole_hei*0.55*y+(-box_x/2+1)*x}
}
